<?php

function array_get( $array, $key )
{
    return array_key_exists( $key, $array ) ? $array[$key] : "";
}

function string_contains( $haystack, $needle )
{
    return (0 == strlen($needle)) || (false !== strpos( $haystack, $needle ));
}

function string_has_prefix( $haystack, $needle )
{
    return (0 == strlen($needle)) || (0 === strpos( $haystack, $needle ));
}

function string_has_suffix( $haystack, $needle )
{
    $expected = strlen( $haystack ) - strlen( $needle );

    return (0 == strlen($needle)) || ($expected === strrpos( $haystack, $needle ));
}

function string_is_json( $provisional )
{
    if ( function_exists( "json_validate" ) )
    {
        return json_validate( $provisional );
    }
    else
    {
        $obj = json_decode( $provisional );

        return is_object( $obj );
    }
}

function test()
{
    if (    string_contains( "www.example.com", ""                ) ) echo "Passed #1" . "\n";
    if (    string_contains( "www.example.com", "www."            ) ) echo "Passed #2" . "\n";
    if (    string_contains( "www.example.com",    ".example."    ) ) echo "Passed #3" . "\n";
    if (    string_contains( "www.example.com",            ".com" ) ) echo "Passed #4" . "\n";
    if (   !string_contains( "www.example.com", "wwl"             ) ) echo "Passed #5" . "\n";
    if (   !string_contains( "www.example.com",    ".exanple"     ) ) echo "Passed #6" . "\n";
    if (   !string_contains( "www.example.com",            ".con" ) ) echo "Passed #7" . "\n";

    if (  string_has_prefix( "www.example.com", ""                ) ) echo "Passed #8" . "\n";
    if (  string_has_prefix( "www.example.com", "www."            ) ) echo "Passed #9" . "\n";
    if (  string_has_prefix( "www.example.com", "www.example."    ) ) echo "Passed #A" . "\n";
    if (  string_has_prefix( "www.example.com", "www.example.com" ) ) echo "Passed #B" . "\n";
    if ( !string_has_prefix( "www.example.com", "wwl"             ) ) echo "Passed #C" . "\n";
    if ( !string_has_prefix( "www.example.com", "www.exanple"     ) ) echo "Passed #D" . "\n";
    if ( !string_has_prefix( "www.example.com", "www.example.con" ) ) echo "Passed #E" . "\n";

    if (  string_has_suffix( "www.example.com", ""                ) ) echo "Passed #F" . "\n";
    if (  string_has_suffix( "www.example.com",            ".com" ) ) echo "Passed #G" . "\n";
    if (  string_has_suffix( "www.example.com",    ".example.com" ) ) echo "Passed #H" . "\n";
    if (  string_has_suffix( "www.example.com", "www.example.com" ) ) echo "Passed #I" . "\n";
    if ( !string_has_suffix( "www.example.com",            ".con" ) ) echo "Passed #J" . "\n";
    if ( !string_has_suffix( "www.example.com",    ".example.con" ) ) echo "Passed #K" . "\n";
    if ( !string_has_suffix( "www.example.com", "www.example.con" ) ) echo "Passed #L" . "\n";
}

