<?php

class Neo
{
    static $neolog_indent;
    static $neolog_connection_id;
    static $neolog_log_level;

    static function Init()
    {
        $strong;
        self::$neolog_connection_id = bin2hex( openssl_random_pseudo_bytes( 2, $strong ) );

        self::$neolog_log_level = intval( getenv( "SHOW_LOG_TO_LEVEL" ) );

        if ( ! is_numeric( self::$neolog_log_level ) )
        {
            self::$neolog_log_level = 100;
        }
    }

    static function In()
    {
        self::$neolog_indent++;
    }

    static function Out()
    {
        if ( 0 < self::$neolog_indent ) self::$neolog_indent--;
    }

    static function Log( $text, $priority = LOG_INFO )
    {
        $indent = intval( self::$neolog_indent    );
        $level  = intval( self::$neolog_log_level );

        if ( $indent <= $level )
        {
            self::LogError( $text, $priority );
        }
    }

    static function LogError( $text, $priority = LOG_ERR )
    {
        $now = isset( $_SERVER ) ? "" : date( DATE_ISO8601 );

        $stars = str_repeat( "+", self::$neolog_indent );

        $text = trim( str_replace( "SQLSTATE[45000]: <<Unknown error>>: 1644", "", $text ) );

        error_log( sprintf( "[%s] %s%-8s %s", self::$neolog_connection_id, $now, $stars, $text ) );

        if ( defined( "USE_SYSLOG_PROGRAMNAME" ) )
        {
            syslog( $priority, $stars . " " . $text );
        }
    }
}

Neo::Init();

function NeoLogAbort( $text )
{
    Neo::LogError( $text, LOG_ERR );
}

function NeoLogError( $text )
{
    Neo::LogError( $text, LOG_ERR );
}

function NeoLogWarning( $text )
{
    Neo::Log( $text, LOG_WARNING );
}

function NeoLogNotice( $text )
{
    Neo::Log( $text, LOG_NOTICE );
}

function NeoLogInfo( $text )
{
    Neo::Log( $text, LOG_INFO );
}

function NeoLog( $text, $priority = LOG_INFO )
{
    Neo::Log( $text, $priority );
}

function NeoLogIn()
{
    Neo::In();
}

function NeoLogOut()
{
    Neo::Out();
}

function NeoLog_DecodeFacility( $facility_name )
{
    switch( $facility_name )
    {
    case "AUTH":
        return LOG_AUTH;

    case "AUTHPRIV":
        return LOG_AUTHPRIV;

    case "DAEMON":
        return LOG_DAEMON;

    case "KERN":
        return LOG_KERN;

    case "LOCAL0":
        return LOG_LOCAL0;

    case "LOCAL1":
        return LOG_LOCAL1;

    case "LOCAL2":
        return LOG_LOCAL2;

    case "LOCAL3":
        return LOG_LOCAL3;

    case "LOCAL4":
        return LOG_LOCAL4;

    case "LOCAL5":
        return LOG_LOCAL5;

    case "LOCAL6":
        return LOG_LOCAL6;

    case "LOCAL7":
        return LOG_LOCAL7;

    case "LPR":
        return LOG_LPR;

    case "MAIL":
        return LOG_MAIL;

    case "NEWS":
        return LOG_NEWS;

    case "SYSLOG":
        return LOG_SYSLOG;

    case "USER":
        return LOG_USER;

    case "UUCP":
        return LOG_UUCP;

    default:
        return LOG_USER;
    }
}

