#!/bin/bash
#
#	Install WebAPIBridge
#

function string_starts_with()
{
    local haystack=$1
    local prefix=$2

    if [ "${haystack}" = "$prefix${haystack/$prefix}" ]
    then
        return 0  # success
    else
        return -1 # failure
    fi
}

if string_starts_with $1 "DOCUMENT_ROOT"
then
	DOCUMENT_ROOT=${1#"DOCUMENT_ROOT="}
fi

VERSION=3.2.5
TARGET="${DOCUMENT_ROOT}/WebAPIBridge/${VERSION}/webapibridge"

if [ "root" != `whoami` ]
then
	echo "Sorry, install.sh must be run as root."

elif [ -z "${VERSION}" ]
then
	echo "Unexpected error - version not set."
	exit -1

elif [ -z "${DOCUMENT_ROOT}" ]
then
	echo "Usage: ./install.sh DOCUMENT_ROOT=<Apache Document Root>"
	exit -1

else
	echo "Installing to ${DOCUMENT_ROOT}/WebAPIBridge/${VERSION}/webapibridge"
	mkdir -p ${TARGET}/{bin,configuration,libexec,sbin,share/apache2}

	cp -f  configuration/conf.php          ${TARGET}/configuration
	cp -rf libexec/*                       ${TARGET}/libexec
	cp -rf sbin/{*.php,dep}                ${TARGET}/sbin

	sed "s|%DOCUMENT_ROOT%|${DOCUMENT_ROOT}|g" share/apache2/wab_template.conf                   > ${TARGET}/share/apache2/wab_template.conf
	sed "s|%DOCUMENT_ROOT%|${DOCUMENT_ROOT}|g" libexec/generate_apache_configuration/generate.sh > ${TARGET}/bin/generate.sh

	chmod +x ${TARGET}/bin/generate.sh

	${TARGET}/libexec/install_apache/install_apache.sh
	${TARGET}/libexec/install_certbot/install_certbot.sh

fi

