<?php
//  Copyright (c) 2015 Daniel Robert Bradley. All rights reserved.
//  This software is distributed under the terms of the GNU Lesser General Public License version 2.1
?>
<?php

class JStream
{
    static function Encode( $indent, $something )
    {
        if ( is_array( $something ) )
        {
            self::EncodeArray( $indent, $something );
        }
        else
        {
            self::EncodeObject( $indent, $something );
        }
    }

    static function EncodeResults( $indent, $results )
    {
        echo "{";
        
        if ( is_array( $results ) && (0 < count( $results ) ) )
        {
            echo '"results":';
            echo "[";
            
            $sep = "";
            
            foreach ( $results as $tuple )
            {
                echo $sep;
                self::EncodeTuple( $index + 1, $tuple );
                $sep = ",";
            }
            
            echo "]";
        }
        
        echo "}";
    }

    static function EncodeTuple( $indent, $tuple )
    {
        echo "\n" . str_repeat( " ", $indent * 4 ) . "{";
        $sep = "";
    
        foreach ( $tuple as $key => $value )
        {
            echo $sep;

            self::EncodeStringValue( $indent + 1, $key, $value );

            $sep = ",";
        }

        echo "\n" . str_repeat( " ", $indent * 4 ) . "}";
    }

    static function EncodeArray( $indent, $array )
    {
        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "[";
        $sep = "";
        
        if ( self::is_assoc( $array ) )
        {
            foreach ( $array as $string => $value )
            {
                echo $sep . "{";
                
                self::EncodeStringValue( $indent + 1, $string, $value );
                
                echo "}";

                $sep = ",";
            }
        }
        else
        {
            foreach ( $array as $value )
            {
                echo $sep;
                
                self::EncodeValue( $indent + 1, $value );
                
                $sep = ",";
            }
        }

        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "]";
    }

    static function EncodeObject( $indent, $object )
    {
        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "{";
        $sep = "";

        foreach ( $object as $member => $value )
        {
            echo $sep;
            
            self::EncodeStringValue( $indent + 1, $member, $value );

            $sep = ",";
        }

        if ( property_exists( $object, "results" ) )
        {
            $results = $object->results;

            //
            //  This must happen _after_ the results have been sent.
            //
            $count = is_array( $results ) ? count( $results ) : (is_a( $results, 'Results' ) ? $results->numRows() : '?');

            echo $sep . "\n";
            echo str_repeat( " ", ($indent + 1) * 4 );
            echo json_encode( "count" );
            echo ":";
            echo json_encode( $count );
        }

        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "}";
    }

    static function EncodeStringValue( $indent, $string, $value )
    {
        echo "\n" . str_repeat( " ", $indent * 4 );

        if ( is_string( $value ) )
        {
            $headers = apache_request_headers();

            if ( array_key_exists( 'Accept', $headers ) )
            {
                switch( $headers['Accept'] )
                {
                case "application/json":
                    $value = html_entity_decode( $value, ENT_QUOTES );
                    $value = str_replace( "<br>", "\n", $value );
                    break;
                }
            }
        }

        if ( string_has_prefix( $string, "__json_" ) )
        {
            self::EncodeString( $indent, substr( $string, 7 ) );
            echo ":";
            echo json_encode( json_decode( $value ) );
        }
        else
        {
            self::EncodeString( $indent, $string );
            echo ":";
            self::EncodeValue( $indent, $value );
        }
    }

    static function EncodeString( $indent, $string )
    {
        $escaped = json_encode( $string ); // str_replace( "\\", "\\\\", $string );

        if ( false === $escaped )
        {
            error_log( "ERROR1: " . var_export( $string,  true ) );
            $escaped = json_encode( htmlentities( $string ) );
        }

        if ( false === $escaped )
        {
            error_log( "ERROR2: " . var_export( $string,  true ) );
            $escaped = json_encode( "" );
        }

        echo $escaped;
    }

    static function EncodeValue( $indent, $value )
    {
        if ( true === $value )
        {
            echo "true";
        }
        else
        if ( false === $value )
        {
            echo "false";
        }
        else
        if ( is_array( $value ) )
        {
            self::EncodeArray( $indent, $value );
        }
        else
        if ( is_string( $value ) )
        {
            self::EncodeString( $indent, $value );
        }
        else
        if ( is_numeric( $value ) )
        {
            self::EncodeNumber( $indent, $value );
        }
        else
        if ( is_null( $value ) )
        {
            echo "null";
        }
        else
        if ( is_a( $value, 'Results' ) )
        {
            if ( $value->isProcessed() )
            {
                //  This should never be executed because the 'Results' object
                //  is only every "processed" by the TranslateToCSV code path
                //  which is orthogonal to this one...
                //  I will remove this when I remove the "map" code path
                //  from TranslateToCSV.

                NeoLog( "Abort!!! Invalid code path." );
                //$array = $value->toArray();
                //self::EncodeArray( $indent, $array );
            }
            else
            {
                self::EncodeResultArray( $indent, $value );
            }
        }
        else
        {
            self::EncodeObject( $indent, $value );
        }
    }

    static function EncodeResultArray( $indent, $result_array, $single = false )
    {
        if ( is_null( $result_array ) )
        {
            echo "null";
        }
        else
        {
            $it    = $result_array->iterator();
            $first = $it->hasNext() ? $it->next() : null;
            $more  = $it->hasNext();

            if ( $single && $first && !$more )
            {
                \JStream::EncodeValue( $indent, $first );
            }
            else
            if ( !$first )
            {
                echo "\n" . str_repeat( " ", $indent * 4 );
                echo "[]";
            }
            else
            {
                echo "\n" . str_repeat( " ", $indent * 4 );
                echo "[";
                {
                    if ( $first )
                    {
                        \JStream::EncodeValue( $indent + 1, $first );
                    }

                    if ( $more )
                    {
                        while ( $it->hasNext() )
                        {
                            $value = $it->next();

                            echo ",";
                            \JStream::EncodeValue( $indent + 1, $value );

                            unset( $value ); $value = null;
                        }
                    }
                }
                echo "\n" . str_repeat( " ", $indent * 4 );
                echo "]";
            }
        }
    }

    static function EncodeNumber( $indent, $number )
    {
        echo json_encode( $number );
    }

    static function is_assoc( $a )
    {
        $assoc = true;
    
        $keys = array_keys( $a );
        foreach ( $keys as $key )
        {
            if ( is_numeric( $key ) && (0 == $key) ) $assoc = false;
            break;
        }
        return $assoc;
    }

    static function is_assocx( $a )
    {
        $b = array_keys($a);

        return ($a != array_keys($b));
    }
}

