<?php

class CSV
{
    static $newline = "\r\n";


    static function PlainText()
    {
        header( "Content-Type: text/plain" );
    }

    static function InitiateDownload( $filename="download.csv" )
    {
        header( "Content-Type: application/octet-stream" );
        header( "Content-Disposition: attachment; filename=\"$filename\"" );
        header("Pragma: public");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    }

    static function encode( $results, $numbered = true, $double_spaced = false )
    {
        $ret = "";

        if ( is_array( $results ) && (0 < count( $results ) ) )
        {
            $ret .= CSV::Heading( $results, $numbered );
            $ret .= CSV::Rows( $results, $numbered, $double_spaced );
        }
        
        return $ret;
    }

    static function Echo( $results, $numbered = true, $double_spaced = false )
    {
        if ( is_a( $results, 'Results' ) )
        {
            $it = $results->iterator();

            if ( $it->hasNext() )
            {
                NeoLog( "CSV::Echo" );

                CSV::EchoHeading( $it, $numbered );
                CSV::EchoRows   ( $it, $numbered, $double_spaced );
            }
        }
    }

    static function EchoHeading( $it, $numbered )
    {
        $heading = "";
    
        if ( $it->hasFirst() )
        {
            $tuple = $it->getFirst();
            $sep   = "";
        
            foreach ( $tuple as $key => $value )
            {
                $heading .= $sep;
                $heading .= $key;
                $sep = ",";
            }

            unset( $tuple ); $tuple = null;
        }
        if ( $numbered ) $heading .= ",#";

        echo $heading .= self::$newline;
    }
    
    static function Heading( $it, $numbered )
    {
        $heading = "";
    
        foreach ( $results as $tuple )
        {
            $sep = "";
        
            foreach ( $tuple as $key => $value )
            {
                $heading .= $sep;
                $heading .= $key;
                $sep = ",";
            }
            break;
        }
        if ( $numbered ) $heading .= ",#";

        return $heading .= self::$newline;
    }

    static function EchoRows( $it, $numbered, $double_spaced = false )
    {
        $nr  = 0;
    
        while ( $it->hasNext() )
        {
            $tuple = $it->next();
            $row   = "";
            $sep   = "";

            $nr++;
        
            if ( $tuple )
            {
                foreach ( $tuple as $key => $value )
                {
                    $row .= $sep;

                    $value = html_entity_decode( $value, ENT_QUOTES );

                    if ( string_contains( $value, "," ) )
                    {
                        $row .= "\"$value\"";
                    }
                    else
                    {
                        $row .= "$value";
                    }
                    $sep = ",";
                }
                if ( $numbered ) $row .= ",$nr";

                if ( $double_spaced ) $row .= self::$newline;
            }

            $row .= self::$newline;

            echo $row;

            unset( $tuple ); $tuple = null;

            flush();
        }
    }

    static function Rows( $results, $numbered, $double_spaced = false )
    {
        $nr   = 0;
        $rows = "";
    
        foreach ( $results as $tuple )
        {
            $nr++;
            $sep = "";
        
            foreach ( $tuple as $key => $value )
            {
                $rows .= $sep;

                $value = html_entity_decode( $value, ENT_QUOTES );

                if ( string_contains( $value, "," ) )
                {
                    $rows .= "\"$value\"";
                }
                else
                {
                    $rows .= "$value";
                }
                $sep = ",";
            }
            if ( $numbered ) $rows .= ",$nr";

            $rows .= self::$newline;

            if ( $double_spaced ) $rows .= self::$newline;
        }

        return $rows;
    }
    
    static function MapValues( $map, $tuples )
    {
        $mapped_tuples = array();
    
        foreach ( $tuples as $obj )
        {
            $tuple  = (array) $obj;
            $mapped = array();
            
            foreach ( $map as $label => $key )
            {
                if ( array_key_exists( $key, $tuple ) )
                {
                    $mapped[$label] = $tuple[$key];
                }
                else
                {
                    error_log( "Could not find $key in tuple." );
                }
            }
            
            $mapped_tuples[] = $mapped;
        }
        
        return $mapped_tuples;
    }
}

