#!/bin/bash

BASEDIR=""
TEMPLATE=""
APACHE2_CONF=""
RUN_CERTBOT=""

function Main()
{
    Environment "$@" &&
    Usage       "$@" &&
    Generate    "$@" &&
    Restart
}

function Environment()
{
    local exe="$0"

    if [ "/" != "${exe:0:1}" ]
    then
        echo "Error: generate.sh must be executed using absolute path"
        return -1
    fi

    #BASEDIR="$(echo ${exe} | awk -F'WEB_API_BRIDGE' '{print $1}')WEB_API_BRIDGE"
    GEN_DIR=`dirname "$exe"`
    LIBEXEC_DIR=`dirname "$GEN_DIR"`
    BASE_DIR=`dirname "$LIBEXEC_DIR"`
    LATEST_DIR=`dirname "$BASE_DIR"`
    PKG_DIR=`dirname "$LATEST_DIR"`
    DOCUMENT_ROOT=`dirname "$PKG_DIR"`

    TEMPLATE="$BASE_DIR/share/apache2/wab_template.conf"
    APACHE2_CONF="/etc/apache2/sites-enabled"
    RUN_CERTBOT="${BASE_DIR}/libexec/run_certbot/run_certbot.sh"

    if [ ! -f "$TEMPLATE" ]
    then
        echo "Error: could not find template file: $TEMPLATE"
        return -1
    fi
}

function Usage()
{
    if [ -z "$1" ]
    then
        echo "Usage: /.../generate.sh <domain> ..."
        return -1
    fi
}

function Generate()
{
    while [ -n "$1" ]
    do
            MakeConf "$1"
            shift
    done
}

    function MakeConf()
    {
        local domain=$1
        local target="${APACHE2_CONF}/api.${domain}.conf"
        local docroot="$DOCUMENT_ROOT"

        echo "Generating: $target"

        if [ ! -f "$target" ]
        then
            cat "${TEMPLATE}" | sed "s|%DOMAIN%|${domain}|g" | sed "s|%DOCUMENT_ROOT%|${docroot}|g" > "$target"
        fi

        if [ ! -f "$target" ]
        then
            echo "Error: target file not created as expected."
        fi
    }

function Restart()
{
    if apachectl configtest
    then
        service apache2 restart
    else
        echo "Warning: Apache syntax check failed: please check syntax of generated file."
    fi
}

Main "$@"
