<?php

function ConfigureSSL( $mysqli, $ssl_base, $host )
{
    if ( file_exists( "$ssl_base/$host/client-key.pem" ) )
    {
        mysqli_ssl_set
        (
            $mysqli,
            "$ssl_base/$host/client-key.pem",
            "$ssl_base/$host/client-cert.pem",
            "$ssl_base/$host/ca-cert.pem",
            NULL,
            NULL
        );
    }
    else
    if ( file_exists( "$ssl_base/$host/server-ca.pem" ) )
    {
        NeoLog( "Warning: not using x509 authenication as cannot find client key/cert." );

        mysqli_ssl_set
        (
            $mysqli,
            NULL,
            NULL,
            "$ssl_base/$host/server-ca.pem",
            NULL,
            NULL
        );
    }
    else
    if( "localhost" != $host )
    {
        NeoLog( "Could not locate SSL files: " . "$ssl_base/$host/client-key.pem" );
    }
}

