<?php

function MySQLCreate()
{
    //NeoLog( 3, "DB_HOSTNAME: " . DB_HOSTNAME );
    //NeoLog( 3, "DB_USERNAME: " . DB_USERNAME );
    //NeoLog( 3, "DB_PASSWORD: " . DB_PASSWORD );
    //NeoLog( 3, "SSL_BASE:    " . SSL_BASE    );

    $m = mysqli_init();

    if ( !$m )
    {
        NeoLogError( "Could not initialise 'mysqli'" );
        exit;
    }

    if ( MYSQLI_OPT_READ_TIMEOUT )
    {
        if ( defined( "USE_MYSQLI_OPT_READ_TIMEOUT" ) )
        {
            mysqli_options( $m, MYSQLI_OPT_READ_TIMEOUT, USE_MYSQLI_OPT_READ_TIMEOUT );
        }
    }
    else
    {
        NeoLog( "Read timeout not supported" );
    }

    ConfigureSSL( $m, SSL_BASE, DB_HOSTNAME );

    try
    {
        $connection = @$m->real_connect( DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, null, null, null, MYSQLI_CLIENT_SSL_DONT_VERIFY_SERVER_CERT );
    }
    catch ( Exception $e )
    {
        $msg = $e->getMessage();

        if ( string_contains( $msg, "Temporary failure in name resolution" ) )
        {
            $msg = "ensure database name is correct";
        }
        $db = DB_HOSTNAME;

        NeoLogError( "503 -- aborting, could connect to database $db ($msg)" );
        http_response_code( 503 );
        exit;
    }

    if ( !$connection )
    {
        if ( "No such file or directory" == $m->error )
        {
            NeoLogError( "Aborting: could not connect to " . DB_HOSTNAME . " using " . DB_USERNAME . ":" . DB_PASSWORD );
            exit;
        }
        else
        if ( "php_network_getaddresses: getaddrinfo failed: Name or service not known" == $m->error )
        {
            NeoLogError( "Aborting: could not resolve: " . DB_HOSTNAME );
            exit;
        }
        else
        {
            NeoLogError( "Aborting: unexpected error: " . $m->error );
            exit;
        }
    }

    return $m; // Same as $m.
}

function MySQLClose( $m )
{
    mysqli_close( $m );
}

function MySQLInfo( $mysql, $sql_query )
{
    $tuples   = array();
    $resource = mysqli_query( $mysql, $sql_query );

    if ( !$resource )
    {
        NeoLog( $mysql->error );
        exit;
    }
    else
    {
        while ( $row = mysqli_fetch_array( $resource, MYSQLI_ASSOC ) )
        {
            $tuples[] = $row;
        }
    }
    return $tuples;
}

function MySQLFunction( $db, $function )
{
    $ret      = null;
    $sql      = "SELECT $function";
    $m        = MySQLCreate();

    if ( ! mysqli_select_db( $m, $db ) )
    {
        NeoLogError( "Aborting, could not select database! " . $db );
        http_response_code( 502 );
        exit;
    }
    else
    {
        $resource = null;
        try
        {
            $resource = mysqli_query( $m, $sql );
        }
        catch ( Exception $e )
        {
            //  MySQL thrown errors seem to be now throwing exceptions...
            //  Is this a MariaDB thing; or updated phpmysqli...
            //
            $msg = $e->getMessage();

            if ( string_contains( $msg, "SELECT command denied" ) )
            {
                $msg = "ensure database has been Activated";
            }

            NeoLogError( "503 -- aborting, could not retrieve parameters from $db ($msg)" );
            http_response_code( 503 );
            exit;
        }

        if ( True === $resource )
        {
            $ret = True;
        }
        else
        if( False === $resource )
        {
            $ret = False;
        }
        else
        if ( $resource )
        {
            $row = mysqli_fetch_array( $resource, MYSQLI_NUM );
            $ret = array_key_exists( 0, $row ) ? $row[0] : NULL;
            mysqli_free_result( $resource );
        }
        else
        {
            NeoLogAbort( "Aborting, " . $m->error );
            exit;
        }
        mysqli_next_result( $m );
    }

    MySQLClose( $m );

    return $ret;
}

function MySQLProcedure( $db, $sp_call, &$procedure = "" )
{
    $ret = False;

    if ( !is_object( $sp_call ) )
    {
        debug_backtrace();
    }

    $proc_name = $sp_call->proc_name;
    $arguments = $sp_call->arguments;

    $m = MySQLCreate();

    if ( ! mysqli_select_db( $m, $db ) )
    {
        NeoLog( "Aborting, could not select database! " . $db );
        MySQLClose( $m );
        exit;
    }
    else
    {
        $count    = 0;
        $filtered = array();
        foreach( $arguments as $argument )
        {
            if ( is_null( $argument ) )
            {
                $filtered[] = "NULL";
            }
            else
            {
                $filtered[] = "'" . mysqli_real_escape_string( $m, $argument ) . "'";
            }
        }

        $procedure = $proc_name . "(" . join( ",", $filtered ) . ")";

        $sql_query = "CALL " . $procedure;

        if ( "wab_test" == $proc_name )
        {
            NeoLog( "Test: " . $sql_query );
        }

        try
        {
            $resource  = mysqli_query( $m, $sql_query );
        }
        catch ( Exception $e )
        {
            //  MySQL thrown errors seem to be now throwing exceptions...
            //  Is this a MariaDB thing; or updated phpmysqli...
            //
            $resource = False;
            $ret = $e->getMessage();
        }

        if ( True === $resource )
        {
            $ret = array();
        }
        else
        if( False === $resource )
        {
            $ret = $m->error;
        }
        else
        if ( $resource )
        {
            $ret = array();

            while ( $row = mysqli_fetch_array( $resource, MYSQLI_ASSOC ) )
            {
                $ret[] = (object) $row;
                $count++;
            }

            mysqli_free_result( $resource );
        }
        else
        {
            NeoLogError( "Called: " . $sql_query . ": threw ERROR: " . $m->error );
            MySQLClose( $m );
            exit;
        }
        mysqli_next_result( $m );

        if ( "TRUE" == getenv( "LOG_STORED_PROCEDURE_CALL" ) )
        {
            NeoLogError( "Called: " . $sql_query . ": returned " . $count . " rows" );
        }
    }

    MySQLClose( $m );

    return $ret;
}

class ResultIterator
{
    protected $m;
    protected $result;
    protected $row;
    protected $count = 0;

    function __construct( $anM, $aResult )
    {
        $this->m      = $anM;
        $this->result = $aResult;
        $this->row    = mysqli_fetch_array( $this->result, MYSQLI_ASSOC );
        $this->first  = $this->row;
    }

    function __destruct()
    {
        mysqli_free_result( $this->result );
        mysqli_next_result( $this->m      );
        MySQLClose        ( $this->m      );
    }

    function hasFirst()
    {
        return $this->first ? true : false;
    }

    function getFirst()
    {
        return (object) $this->first;
    }

    function hasNext()
    {
        return $this->row ? true : false;
    }

    function next()
    {
        $ret       = $this->row;
        $this->row = null;
        $this->row = mysqli_fetch_array( $this->result, MYSQLI_ASSOC );

        $this->count++;

        return (object) $ret;
    }

    function getCount()
    {
        return $this->count;
    }
}

class Results
{
    public    $sqlQuery;
    protected $it;
    protected $array;
    protected $result;

    function __construct( $sql_query, $anM, $aResult )
    {
        $this->sqlQuery = $sql_query;
        $this->it       = new ResultIterator( $anM, $aResult );
        $this->array    = null;
        $this->result   = $aResult;
    }

    function hasFirst()
    {
        return $this->it->hasFirst();
    }

    function getFirst()
    {
        return $this->it->getFirst();
    }


    //  Called by OutputResponse.TranslateToCSV
    function toArray()
    {
        if ( is_null( $this->array ) )
        {
            $this->array = array();

            while ( $this->it->hasNext() )
            {
                $this->array[] = (object) $this->it->next();
            }
        }

        return $this->array;
    }

    function toStringX()
    {
        return var_export( $this->array, true );
    }

    function isProcessed()
    {
        return !is_null( $this->array );
    }

    function encodeArrayX( $indent )
    {
        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "[";
        $sep = "";

        while ( $this->it->hasNext() )
        {
            $value = (object) $this->it->next();

            echo $sep;
            \JStream::EncodeValue( $indent + 1, $value ); 
            $sep = ",";
        }

        echo "\n" . str_repeat( " ", $indent * 4 );
        echo "]";
    }

    function iterator()
    {
        return $this->it;
    }

    function numRows()
    {
        return $this->it->getCount();
        //return mysqli_num_rows( $this->result );
    }
}

class EmptyResults
{
    public    $sqlQuery;
    protected $array;

    function __construct( $sql_query )
    {
         $this->sqlQuery = $sql_query;
         $this->array    = array();
    }

    function numRows()
    {
        return 0;
    }
}

class ErrorResults
{
    public    $sqlQuery;
    public    $errorMessage;
    public    $sqlstate;

    function __construct( $sql_query, $error_message, $sqlstate = "45000" )
    {
         $this->sqlQuery     = $sql_query;
         $this->errorMessage = $error_message;
         $this->sqlstate     = $sqlstate;
    }

    function numRows()
    {
        return 'None';
    }
}

function MySQLProcedureResults( $db, $sp_call, &$procedure = "" )
{
    $ret = False;

    if ( !is_object( $sp_call ) )
    {
        debug_backtrace();
    }

    $proc_name = $sp_call->proc_name;
    $arguments = $sp_call->arguments;

    $m = MySQLCreate();

    if ( ! mysqli_select_db( $m, $db ) )
    {
        NeoLogError( "Aborting, could not select database! " . $db );
        MySQLClose( $m );
        exit;
    }
    else
    {
        $filtered = array();
        foreach( $arguments as $argument )
        {
            if ( is_null( $argument ) )
            {
                $filtered[] = "NULL";
            }
            else
            {
                $filtered[] = "'" . mysqli_real_escape_string( $m, $argument ) . "'";
            }
        }

        $procedure = $proc_name . "(" . join( ",", $filtered ) . ")";

        $sql_query = "CALL " . $procedure;

        if ( "wab_test" == $proc_name )
        {
            NeoLog( "Test: " . $sql_query );
        }

        try
        {
            $resource  = mysqli_query( $m, $sql_query, MYSQLI_USE_RESULT );
        }
        catch ( Exception $e )
        {
            //  MySQL thrown errors seem to be now throwing exceptions...
            //  Is this a MariaDB thing; or updated phpmysqli...
            //
            $resource      = False;
            $error_message = $e->getMessage();
            $ret           = new ErrorResults( $sql_query, $error_message, $m->sqlstate );
        }

        if ( "auth_login" == strtolower( $proc_name ) )
        {
            $sql_query = "CALL auth_login( [hidden] )";
        }

        if ( True === $resource )
        {
            $ret = new EmptyResults( $sql_query );
        }
        else
        if( False === $resource )
        {
            $ret = new ErrorResults( $sql_query, $m->error, $m->sqlstate );
        }
        else
        if ( $resource )
        {
            $ret = new Results( $sql_query, $m, $resource );
        }
        else
        {
            NeoLog( "Aborting, " . $m->error );
            MySQLClose( $m );
            exit;
        }
    }

    if ( !is_a( $ret, 'Results' ) )
    {
        mysqli_next_result( $m );
        MySQLClose( $m );
    }

    return $ret;
}

